#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501

#include <tchar.h>
#include <windows.h>
#include <commctrl.h>

#define IDC_BUTTON01 1001
#define IDC_BUTTON02 1002

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

HWND hwndButton01, hwndButton02;

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("Custom Draw Button"), /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           400,                 /* The programs width */
           300,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/* This function is called by the Windows function DispatchMessage() */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
         case WM_CREATE:
         {
              // Custom Draw button
              hwndButton01 = CreateWindowEx(0, "BUTTON", "Button01",
                                 WS_CHILD | WS_VISIBLE, 20, 20, 120, 25,
                                 hwnd, (HMENU) IDC_BUTTON01, NULL, NULL);

              hwndButton02 = CreateWindowEx(0, "BUTTON", "Button02",
                                 WS_CHILD | WS_VISIBLE, 20, 60, 120, 25,
                                 hwnd, (HMENU) IDC_BUTTON02, NULL, NULL);
         }
         break;

         case WM_COMMAND:
         {
              if (HIWORD(wParam) == BN_CLICKED) {
                  switch(LOWORD(wParam)) {
                    case IDC_BUTTON01:
                         MessageBox(NULL, "Button01 tkland.", "Buton tklama", MB_OK);
                         break;
                    case IDC_BUTTON02:
                         MessageBox(NULL, "Button02 tkland.", "Buton tklama", MB_OK);
                         break;
                  }
              }
         }
         break;

         case WM_NOTIFY:
         {
              LPNMHDR lpnmhdr = (LPNMHDR)lParam;
              HBRUSH hBrushBack;

              if ((lpnmhdr->hwndFrom == hwndButton01) || (lpnmhdr->hwndFrom == hwndButton02)) {
                  char cdizi[40];
                  switch(lpnmhdr->code) {
                    case NM_CUSTOMDRAW:
                         LPNMCUSTOMDRAW lpnmcd = (LPNMCUSTOMDRAW)lpnmhdr;

                         if (lpnmcd->uItemState & CDIS_SELECTED) { // Butona tklaynca
                             hBrushBack = CreateSolidBrush(RGB(170, 170, 50));
                             SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                         }
                         else {
                             if (lpnmcd->uItemState & CDIS_HOT) { // Mouse buton zerinde
                                 hBrushBack = CreateSolidBrush(RGB(210, 110, 60));
                                 SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                             }
                             else {
                                 hBrushBack = CreateSolidBrush(RGB(190, 90, 40));
                                 SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                             }
                         }
                         SetBkMode(lpnmcd->hdc, TRANSPARENT);
                         FillRect(lpnmcd->hdc, &lpnmcd->rc, hBrushBack);
                         DeleteObject(hBrushBack);
                         GetWindowText(lpnmhdr->hwndFrom, cdizi, sizeof(cdizi));
                         DrawText(lpnmcd->hdc, cdizi, strlen(cdizi), &lpnmcd->rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

                         return CDRF_SKIPDEFAULT;
                  }
              }
         }
         break;

         case WM_DESTROY:
             PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
             break;

         default:                       /* for messages that we don't deal with */
             return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}
