#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501

#include <tchar.h>
#include <windows.h>
#include <commctrl.h>
#include "resource.h"

/* Declare Windows procedure */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);
/* Subclassing fonksiyon bildirimi */
LRESULT CALLBACK ButtonProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

HWND hwndButton01, hwndButton02;
HANDLE iconButton01, iconButton02;

/* Subclassing fonksiyonu iinde WM_MOUSEMOVE mesajn takip eden deikenler */
int inButton;
HWND hwndButton;

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("Icon Button"), /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           400,                 /* The programs width */
           300,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/* This function is called by the Windows function DispatchMessage() */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
         case WM_CREATE:
         {
              // Icon button oluturma
              hwndButton01 = CreateWindowEx(0, "BUTTON", "",
                                 WS_CHILD | WS_VISIBLE | BS_ICON, 20, 20, 32, 32,
                                 hwnd, (HMENU) IDC_BUTTON01, NULL, NULL);

              iconButton01 = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONBUTTON01), IMAGE_ICON, 16, 16, LR_SHARED);
              // Butona resim atama
              SendMessage(hwndButton01, BM_SETIMAGE, (WPARAM)IMAGE_ICON, (LPARAM)iconButton01);

              hwndButton02 = CreateWindowEx(0, "BUTTON", "",
                                 WS_CHILD | WS_VISIBLE | BS_ICON, 20, 60, 32, 32,
                                 hwnd, (HMENU) IDC_BUTTON02, NULL, NULL);

              iconButton02 = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONBUTTON02), IMAGE_ICON, 16, 16, LR_SHARED);
              // Butona resim atama
              SendMessage(hwndButton02, BM_SETIMAGE, (WPARAM)IMAGE_ICON, (LPARAM)iconButton02);
         }
         break;

         case WM_COMMAND:
         {
              if (HIWORD(wParam) == BN_CLICKED) {
                  switch(LOWORD(wParam)) {
                    case IDC_BUTTON01:
                         MessageBox(NULL, "Button01 tkland.", "Buton tklama", MB_OK);
                         break;
                    case IDC_BUTTON02:
                         MessageBox(NULL, "Button02 tkland.", "Buton tklama", MB_OK);
                         break;
                  }
              }
         }
         break;

         case WM_DESTROY:
             PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
             break;

         default:                       /* for messages that we don't deal with */
             return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}
