#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501

#include <tchar.h>
#include <windows.h>
#include <commctrl.h>

#define IDC_BUTTON01 1001
#define IDC_BUTTON02 1002

/* Declare Windows procedure */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);
/* Subclassing fonksiyon bildirimi */
LRESULT CALLBACK ButtonProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

HWND hwndButton01, hwndButton02;

/* Subclassing fonksiyonu iinde WM_MOUSEMOVE mesajn takip eden deikenler */
int inButton;
HWND hwndButton;

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("Owner Drawn Button"), /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           400,                 /* The programs width */
           300,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/* This function is called by the Windows function DispatchMessage() */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
         case WM_CREATE:
         {
              // Owner drawn button
              hwndButton01 = CreateWindowEx(0, "BUTTON", "Button01",
                                 WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, 20, 20, 120, 25,
                                 hwnd, (HMENU) IDC_BUTTON01, NULL, NULL);
              // Subclassing ilemi uygulama
              SetWindowSubclass(hwndButton01, ButtonProc, 0, 0);

              hwndButton02 = CreateWindowEx(0, "BUTTON", "Button02",
                                 WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, 20, 60, 120, 25,
                                 hwnd, (HMENU) IDC_BUTTON02, NULL, NULL);
              SetWindowSubclass(hwndButton02, ButtonProc, 0, 0);
         }
         break;

         case WM_COMMAND:
         {
              if (HIWORD(wParam) == BN_CLICKED) {
                  switch(LOWORD(wParam)) {
                    case IDC_BUTTON01:
                         MessageBox(NULL, "Button01 tkland.", "Buton tklama", MB_OK);
                         break;
                    case IDC_BUTTON02:
                         MessageBox(NULL, "Button02 tkland.", "Buton tklama", MB_OK);
                         break;
                  }
              }
         }
         break;

         case WM_DRAWITEM:
         {
            switch ((UINT)wParam) {
                case IDC_BUTTON01:
                case IDC_BUTTON02:
                {
                     LPDRAWITEMSTRUCT lpdis = (DRAWITEMSTRUCT*)lParam;
                     SIZE size;
                     char cdizi[40];

                     if (inButton && (hwndButton == lpdis->hwndItem)) { // Mouse buton zerinde
                         SetBkColor(lpdis->hDC, RGB(201, 29, 201));
                         SetTextColor(lpdis->hDC, RGB(236, 236, 236));
                     }
                     else {
                         SetBkColor(lpdis->hDC, RGB(146, 27, 146));
                         SetTextColor(lpdis->hDC, RGB(220, 220, 220));
                     }
                     GetWindowText(lpdis->hwndItem, cdizi, sizeof(cdizi));

                     GetTextExtentPoint32(lpdis->hDC, cdizi, strlen(cdizi), &size);
                     ExtTextOut(lpdis->hDC, ((lpdis->rcItem.right - lpdis->rcItem.left) - size.cx) / 2,
                                ((lpdis->rcItem.bottom - lpdis->rcItem.top) - size.cy) / 2,
                                ETO_OPAQUE | ETO_CLIPPED, &lpdis->rcItem, cdizi, strlen(cdizi), NULL);

                     return TRUE;
                }
                break;
            }
         }
         break;

         case WM_DESTROY:
             PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
             break;

         default:                       /* for messages that we don't deal with */
             return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

/* Subclassing fonksiyonu */
LRESULT CALLBACK ButtonProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData)
{
  switch (message) {

    case WM_MOUSEMOVE:
     {
         hwndButton = hwnd;

         if (GetCapture() != hwnd) {
            // Mouse button penceresine henz girdi.
            inButton=1;
            SetCapture(hwnd);
            InvalidateRect(hwnd, NULL, TRUE);

         }
         else {
            RECT rect;
            POINT pt = { LOWORD(lParam), HIWORD(lParam) };

            GetWindowRect(hwnd, &rect);
            ClientToScreen(hwnd, &pt);

            if (!PtInRect(&rect, pt)) {
                // Mouse button penceresinden ayrld.
                inButton=0;
                ReleaseCapture();
                InvalidateRect(hwnd, NULL, TRUE);
            }
         }
     }
     break;
  }

  return DefSubclassProc(hwnd, message, wParam, lParam);
}
