#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501

#include <tchar.h>
#include <windows.h>
#include <Commctrl.h>
#include "resource.h"

LRESULT CALLBACK ButtonProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData);
void bgPaintButton(HWND hwnd, HWND hwndButton);

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("DenemeApp");

HWND hwndButton01, hwndButton02, hwndButton03, hwndButton04;
HWND hwndButton05, hwndButton06, hwndButton07, hwndButton08;
HANDLE iconAbout;

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                       /* Extended possibilites for variation */
           szClassName,             /* Classname */
           _T("Deneme Uygulamas"), /* Title Text */
           WS_OVERLAPPEDWINDOW,     /* default window */
           CW_USEDEFAULT,           /* Windows decides the position */
           CW_USEDEFAULT,           /* where the window ends up on the screen */
           544,                     /* The programs width */
           385,                     /* and height in pixels */
           HWND_DESKTOP,            /* The window is a child-window to desktop */
           NULL,                    /* No menu */
           hThisInstance,           /* Program Instance handler */
           NULL                     /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
       case WM_CREATE:

            // Normal buton
            hwndButton01 = CreateWindowEx(0, "BUTTON", "Button01",
                               WS_CHILD | WS_VISIBLE, 20, 20, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON01, NULL, NULL);

            // Sadece icon'dan oluan buton
            hwndButton02 = CreateWindowEx(0, "BUTTON", "",
                               WS_CHILD | WS_VISIBLE | BS_ICON, 20, 60, 32, 32,
                               hwnd, (HMENU) IDC_BUTTON02, NULL, NULL);
            // resource.rc dosyasndan about.ico dosyasn ykleme
            iconAbout = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONABOUT), IMAGE_ICON, 16, 16, LR_SHARED);
            // Butona resim atama
            SendMessage(hwndButton02, BM_SETIMAGE, (WPARAM)IMAGE_ICON, (LPARAM)iconAbout);

            // Owner drawn buton resimli
            hwndButton03 = CreateWindowEx(0, "BUTTON", "Button03",
                               WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, 20, 102, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON03, NULL, NULL);

            // Owner drawn buton resimsiz
            hwndButton04 = CreateWindowEx(0, "BUTTON", "Button04",
                               WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, 20, 142, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON04, NULL, NULL);

            // Subclassed buton ve WM_PAINT yntemi
            hwndButton05 = CreateWindowEx(0, "BUTTON", "Button05",
                               WS_CHILD | WS_VISIBLE, 20, 182, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON05, NULL, NULL);
            SetWindowSubclass(hwndButton05, ButtonProc, 0, 0);

            // Sadece bitmap'den oluan buton
            hwndButton06 = CreateWindowEx(0, "BUTTON", "Button06",
                               WS_CHILD | WS_VISIBLE | BS_BITMAP, 20, 222, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON06, NULL, NULL);
            bgPaintButton(hwnd, hwndButton06);

            // Custom draw buton (Manifest dosyas gerektirir. manifest.xml)
            hwndButton07 = CreateWindowEx(0, "BUTTON", "Button07",
                               WS_CHILD | WS_VISIBLE, 20, 262, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON07, NULL, NULL);

            // WM_CTLCOLORBTN ile buton renklendirme (owner-drawn buton olmas gerekiyor)
            hwndButton08 = CreateWindowEx(0, "BUTTON", "Button08",
                               WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, 20, 302, 120, 30,
                               hwnd, (HMENU) IDC_BUTTON08, NULL, NULL);

            break;

       case WM_COMMAND:
         {
            char btnmsg[20];

            if (HIWORD(wParam) == BN_CLICKED) {
                switch(LOWORD(wParam)) {
                  case IDC_BUTTON01:
                       strcpy(btnmsg, "Button01 tkland.");
                       break;
                  case IDC_BUTTON02:
                       strcpy(btnmsg, "Button02 tkland.");
                       break;
                  case IDC_BUTTON03:
                       strcpy(btnmsg, "Button03 tkland.");
                       break;
                  case IDC_BUTTON04:
                       strcpy(btnmsg, "Button04 tkland.");
                       break;
                  case IDC_BUTTON05:
                       strcpy(btnmsg, "Button05 tkland.");
                       break;
                  case IDC_BUTTON06:
                       strcpy(btnmsg, "Button06 tkland.");
                       break;
                  case IDC_BUTTON07:
                       strcpy(btnmsg, "Button07 tkland.");
                       break;
                  case IDC_BUTTON08:
                       strcpy(btnmsg, "Button08 tkland.");
                       break;
                }
                if (strcmp(btnmsg, "")) MessageBox(NULL, btnmsg, "Buton tklama", MB_OK);
            }
         }
         break;

       case WM_DRAWITEM:
            switch ((UINT)wParam) {
                case IDC_BUTTON03:
                case IDC_BUTTON04:
                {
                    LPDRAWITEMSTRUCT lpdis = (DRAWITEMSTRUCT*)lParam;
                    SIZE size;
                    char btnString[10];

                    if ((UINT)wParam==IDC_BUTTON03) {
                        strcpy(btnString, "Button03");
                        SetBkColor(lpdis->hDC, RGB(200, 180, 40));
                    }
                    else {
                        strcpy(btnString, "Button04");
                        SetBkColor(lpdis->hDC, RGB(146, 27, 146));
                    }

                    SetTextColor(lpdis->hDC, RGB(236, 236, 236));

                    // ETO_OPAQUE seenei ile buton arka plann aktif arka plan rengi ile doldurmay salar.
                    GetTextExtentPoint32(lpdis->hDC, btnString, strlen(btnString), &size);
                    ExtTextOut(lpdis->hDC, ((lpdis->rcItem.right - lpdis->rcItem.left) - size.cx) / 2,
                               ((lpdis->rcItem.bottom - lpdis->rcItem.top) - size.cy) / 2,
                               ETO_OPAQUE | ETO_CLIPPED, &lpdis->rcItem, btnString, strlen(btnString), NULL);

                    // Sadece Button03 butonu iin icon yerletirme
                    if ((UINT)wParam==IDC_BUTTON03) {
                        iconAbout = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONABOUT), IMAGE_ICON, 16, 16, LR_SHARED);
                        DrawIconEx(lpdis->hDC, 5, ((lpdis->rcItem.bottom - lpdis->rcItem.top) - 16) / 2, (HICON)iconAbout, 16, 16, 0, 0, DI_NORMAL);
                    }

                    return TRUE;
                }
                break;
            }

       case WM_NOTIFY:
         {
            LPNMHDR lpnmhdr = (LPNMHDR)lParam;
            HBRUSH hBrushBack;

            switch(lpnmhdr->code) {
              case NM_CUSTOMDRAW:
                 LPNMCUSTOMDRAW lpnmcd = (LPNMCUSTOMDRAW)lpnmhdr;

                 if (lpnmhdr->hwndFrom == hwndButton07) {
                     if (lpnmcd->uItemState & CDIS_SELECTED) { // Butona tklaynca
                         hBrushBack = CreateSolidBrush(RGB(170, 170, 50));
                         SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                     }
                     else {
                         if (lpnmcd->uItemState & CDIS_HOT) { // Mouse buton zerinde
                             hBrushBack = CreateSolidBrush(RGB(210, 110, 60));
                             SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                         }
                         else {
                             hBrushBack = CreateSolidBrush(RGB(190, 90, 40));
                             SetTextColor(lpnmcd->hdc, RGB(236, 236, 236));
                         }
                      }
                      SetBkMode(lpnmcd->hdc, TRANSPARENT);
                      FillRect(lpnmcd->hdc, &lpnmcd->rc, hBrushBack);
                      DeleteObject(hBrushBack);
                      DrawText(lpnmcd->hdc, "Button07", strlen("Button07"), &lpnmcd->rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

                      return CDRF_SKIPDEFAULT;
                 }
            }
         }
         break;

       case WM_CTLCOLORBTN: // BS_OWNERDRAW olmas gerekiyor.
         {
           if ((HWND)lParam==hwndButton08) {
                RECT rc;

                SetTextColor((HDC)wParam, RGB(236, 236, 236));
                SetBkMode((HDC)wParam, TRANSPARENT);
                GetClientRect((HWND)lParam, &rc);
                DrawText((HDC)wParam, "Button08", -1, &rc, DT_SINGLELINE | DT_CENTER | DT_VCENTER);

                return (LRESULT)CreateSolidBrush(RGB(40, 90, 155));
           }
        }
        break;

       case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
       default:                        /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

LRESULT CALLBACK ButtonProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData)
{
  static int inButton;

  switch (message) {

    case WM_PAINT:
         PAINTSTRUCT ps;
         BeginPaint(hwnd, &ps);

         SetTextColor(ps.hdc, RGB(236, 236, 236));
         SetBkMode(ps.hdc, TRANSPARENT);
         if (inButton) FillRect(ps.hdc, &ps.rcPaint, (HBRUSH)CreateSolidBrush(RGB(230, 30, 90)));
         else FillRect(ps.hdc, &ps.rcPaint, (HBRUSH)CreateSolidBrush(RGB(200, 25, 80)));
         DrawText(ps.hdc, "Button05", -1, &ps.rcPaint, DT_SINGLELINE | DT_CENTER | DT_VCENTER);

         EndPaint(hwnd, &ps);

		 break;

    case WM_MOUSEMOVE:
     {
         if (GetCapture() != hwnd) {
            // Mouse button penceresine henz girdi.
            inButton=1;
            SetCapture(hwnd);
         }
         else {
            RECT rect;
            POINT pt = { LOWORD(lParam), HIWORD(lParam) };

            GetWindowRect(hwnd, &rect);
            ClientToScreen(hwnd, &pt);

            if (!PtInRect(&rect, pt)) {
                // Mouse buton penceresinden ayrld.
                inButton=0;
                ReleaseCapture();
            }
         }
     }
     break;
  }

  return DefSubclassProc(hwnd, message, wParam, lParam);
}

void bgPaintButton(HWND hwnd, HWND hwndButton)
{
  HDC hdc, hMemDC;
  HBITMAP hBitmap;
  RECT r = {0};

  hdc = GetDC(hwnd);
  hMemDC = CreateCompatibleDC(hdc);
  hBitmap = CreateCompatibleBitmap(hdc, 120, 30);
  SelectObject(hMemDC, hBitmap);
  SetDCBrushColor(hMemDC, RGB(150, 160, 225));

  r.left = 0;
  r.right = 120;
  r.top = 0;
  r.bottom = 30;

  FillRect(hMemDC, &r, (HBRUSH)GetStockObject(DC_BRUSH));
  SetBkMode(hMemDC, TRANSPARENT);
  SetTextColor(hMemDC, RGB(236, 236, 236));
  DrawText(hMemDC, "Button06", strlen("Button06"), &r, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

  DeleteDC(hMemDC);
  ReleaseDC(hwnd, hdc);

  SendMessage(hwndButton, BM_SETIMAGE, (WPARAM)IMAGE_BITMAP, (LPARAM)hBitmap);
}
