#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0501
#define _WIN32_IE 0x0501

#include <tchar.h>
#include <windows.h>

#define IDC_COMBOBOX 1001

/* Declare Windows procedure */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

HWND hwndComboBox;

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("ComboBox Renkli"), /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           400,                 /* The programs width */
           300,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/* This function is called by the Windows function DispatchMessage() */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
       case WM_CREATE:
       {
            hwndComboBox = CreateWindowEx(0, "COMBOBOX", NULL,
                                 WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST | WS_TABSTOP | CBS_HASSTRINGS | WS_VSCROLL | CBS_OWNERDRAWFIXED,
                                 20, 20, 180, 200,
                                 hwnd, (HMENU)(IDC_COMBOBOX), NULL, NULL);

            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 01");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 02");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 03");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 04");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 05");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 06");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 07");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 08");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 09");
            SendMessage(hwndComboBox, CB_ADDSTRING, 0, (LPARAM) "Karakter dizisi 10");

            SendMessage(hwndComboBox, CB_SETCURSEL, 0, 0);
       }
       break;

       case WM_DRAWITEM:
       {
            COLORREF backgr=0;
            TEXTMETRIC tm;
            int x, y;
            TCHAR achTemp[256];
            LPDRAWITEMSTRUCT lpDrawItem = (LPDRAWITEMSTRUCT) lParam;

            if (lpDrawItem->CtlType==ODT_COMBOBOX) {
                if (wParam == IDC_COMBOBOX) {
                    if (lpDrawItem->itemID == -1) break; // ComboBox bo ise

                    switch ((lpDrawItem->itemID)%5) {
                       case 0: backgr = RGB(200, 100, 245); break;
                       case 1: backgr = RGB(200, 220, 50); break;
                       case 2: backgr = RGB(255, 210, 50); break;
                       case 3: backgr = RGB(252, 170, 255); break;
                       case 4: backgr = RGB(220, 180, 140); break;
                    }

                    SetTextColor(lpDrawItem->hDC, RGB(50, 50, 50));
                    SetBkColor(lpDrawItem->hDC, backgr);

                    // Yatay ve dikey pozisyonu hesaplama
                    GetTextMetrics(lpDrawItem->hDC, &tm);
                    y = (lpDrawItem->rcItem.bottom + lpDrawItem->rcItem.top - tm.tmHeight) / 2;
                    x = LOWORD(GetDialogBaseUnits()) / 4;

                    // Listedeki satr alma ve yazma
                    SendMessage(lpDrawItem->hwndItem, CB_GETLBTEXT, lpDrawItem->itemID, (LPARAM) achTemp);
                    ExtTextOut(lpDrawItem->hDC, x+4, y, ETO_CLIPPED | ETO_OPAQUE, &lpDrawItem->rcItem, achTemp, (UINT)strlen(achTemp), NULL);

                    if ((lpDrawItem->itemState & ODS_FOCUS) && !(lpDrawItem->itemState & ODS_COMBOBOXEDIT)) {
                        FrameRect(lpDrawItem->hDC, &lpDrawItem->rcItem, CreateSolidBrush(RGB(200, 255, 200)));
                    }
                }
            }
       }
       break;

       case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;

       default:                        /* for messages that we don't deal with */
           return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}
