#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

// commctrl.h iindeki baz verilerin kullanm iin gerekli
#define _WIN32_WINNT 0x0601
#define _WIN32_IE 0x0501

#define IDC_LISTVIEW 1001

#include <tchar.h>
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>

HWND ListView;

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

void FillListView(HWND hwnd);
LRESULT CALLBACK ListViewHeaderProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData);
LRESULT CALLBACK ListViewProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("Stun genilii sabit Listview "),       /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           440,                 /* The programs width */
           245,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
        {
             ListView = CreateWindowEx(WS_EX_CLIENTEDGE , WC_LISTVIEW, "",
                                  WS_CHILD | LVS_REPORT | WS_VISIBLE,
                                  10, 10, 400, 185, hwnd,
                                  (HMENU) IDC_LISTVIEW, NULL, NULL);
             ListView_SetExtendedListViewStyle(ListView, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
             SetWindowSubclass(ListView, ListViewProc, 0, 0);
             SetWindowSubclass(ListView_GetHeader(ListView), ListViewHeaderProc, 0, 0);
             FillListView(ListView);

             break;
        }

        case WM_DESTROY:
             PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
             break;
        default:                        /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

LRESULT CALLBACK ListViewHeaderProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData)
{
  switch (message) {
     // mle iaretinin boyutlandrma iaretine dnmesini engelleme
     case WM_SETCURSOR:
     {
          return TRUE;
     }
     // Bala tklama ve ift tklamay engelleme
     case WM_LBUTTONDOWN:
     {
          return 0;
     }
  }

  return DefSubclassProc(hwnd, message, wParam, lParam);
}

LRESULT CALLBACK ListViewProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, UINT_PTR uIdSubclass, DWORD_PTR dwRefData)
{
  switch (message) {
     case WM_NOTIFY:
     {
          switch (((LPNMHDR)lParam)->code) {
             // Listview balk yeniden boyutlandrma ilemini engelleme
             case HDN_BEGINTRACKW:
             case HDN_BEGINTRACKA:
                  return TRUE;
                  break;

          }
          break;
     }
  }

  return DefSubclassProc(hwnd, message, wParam, lParam);
}

void FillListView(HWND hwnd)
{
  LVCOLUMN lvc;
  LVITEM lvI;
  int idCol=4, idItem=10;
  char cdizi[15];
  int id1, id2;

  // LVCOLUMN structure iin ilk deer atama ilemlerini yapar.
  lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
  lvc.cx = 98;           // Stun genilii deeri
  lvc.pszText = cdizi;
  lvc.cchTextMax = sizeof(cdizi);
  lvc.fmt = LVCFMT_LEFT; // Stunlar sol tarafa ayarlar

  // Stun ekleme ilemleri
  for (id1=0; id1<idCol; id1++) {
       lvc.iSubItem = id1;
       sprintf(cdizi, "%s%d", "Column", id1+1);
       lvc.pszText = cdizi;
       // Stun ekleme ilemi
       ListView_InsertColumn(hwnd, id1, &lvc);
  }

  // LVITEM structure iin ilk deer atama ilemlerini yapar.
  lvI.mask      = LVIF_TEXT | LVIF_STATE;
  lvI.stateMask = 0;
  lvI.iSubItem  = 0;
  lvI.state     = 0;

  // Satr ekleme ilemleri
  for (id1=0; id1<idItem; id1++) {
       lvI.iItem  = id1;
       sprintf(cdizi, "%s%d", "Item", id1+1);
       lvI.pszText   = cdizi;
       // lk stun iin e ekleme ilemleri
       ListView_InsertItem(hwnd, &lvI);

       // Dier stunlar iin e ekleme ilemleri
       for (id2=1; id2<idCol; id2++) {
            sprintf(cdizi, "%s%d-%d", "SubItem", id1+1, id2+1);
            ListView_SetItemText(hwnd, id1, id2, cdizi);
       }
  }
}
