#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#define _WIN32_WINNT 0x0601
#define _WIN32_IE 0x0501

#define IDC_STATIC 1001

#include <tchar.h>
#include <windows.h>
#include <stdio.h>

HWND hwndStatic;

// Declare Windows procedure
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);
// letim sistemini alma
void bg_getos(void);

// Make the class name into a global variable
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           _T("Windows iletim sistemi srm"),       /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           440,                 /* The programs width */
           330,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
        {
             hwndStatic = CreateWindowEx(0, "STATIC", "",
                                WS_CHILD | WS_VISIBLE | SS_LEFT, 20, 20, 300, 20,
                                hwnd, (HMENU) IDC_STATIC, NULL, NULL);
             bg_getos();
             break;
        }

        // Statik kontrol arka plan rengini transparent yapmak iin
        case WM_CTLCOLORSTATIC:
        {
             if((HWND)lParam == hwndStatic) {
                HBRUSH hbr = (HBRUSH)DefWindowProc(hwnd, message, wParam, lParam);
                DeleteObject(hbr);
                SetBkMode((HDC)wParam, TRANSPARENT);
                return (LRESULT)GetStockObject(NULL_BRUSH);
             }
        }
        break;

        case WM_DESTROY:
             PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
             break;
        default:                        /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

// letim sistemini alma
void bg_getos(void)
{
  OSVERSIONINFOEX info;
  char cdizi[50];

  ZeroMemory(&info, sizeof(OSVERSIONINFOEX));
  info.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
  GetVersionEx((LPOSVERSIONINFO)&info);

  switch(info.dwMajorVersion) {
     case 10:
          snprintf(cdizi, sizeof(cdizi), "%s ", "Windows 10");
          break;
     case 6:
          switch(info.dwMinorVersion) {
             case 3:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows 8.1");
                  break;
             case 2:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows 8");
                  break;
             case 1:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows 7");
                  break;
             case 0:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows Vista");
                  break;
          }
          break;
     case 5:
          switch(info.dwMinorVersion) {
             case 2:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows XP 64-Bit Edition");
                  break;
             case 1:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows XP");
                  break;
             case 0:
                  snprintf(cdizi, sizeof(cdizi), "%s ", "Windows 2000");
                  break;
          }
          break;
  }

  snprintf(cdizi + strlen(cdizi), sizeof(cdizi) - strlen(cdizi), " Srm: %lu.%lu", info.dwMajorVersion, info.dwMinorVersion);
  SetWindowText(hwndStatic, cdizi);
}
