#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#include <tchar.h>
#include <windows.h>
#include <richedit.h>

/* Eer derleyici hata verirse, aadaki tanmlama yaplmaldr. */
#if !defined MSFTEDIT_CLASS
#define MSFTEDIT_CLASS "RICHEDIT50W"
#endif

#define IDC_RICHEDIT 101

HWND hwndRichedit;

BOOL FillRichEditFromFile(HWND hwnd, LPCTSTR pszFile);
DWORD CALLBACK EditStreamCallback(DWORD_PTR dwCookie, LPBYTE lpBuff, LONG cb, PLONG pcb);

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                      /* Extended possibilites for variation */
           szClassName,            /* Classname */
           _T("Richedit rnei"),  /* Title Text */
           WS_OVERLAPPEDWINDOW,    /* default window */
           CW_USEDEFAULT,          /* Windows decides the position */
           CW_USEDEFAULT,          /* where the window ends up on the screen */
           544,                    /* The programs width */
           375,                    /* and height in pixels */
           HWND_DESKTOP,           /* The window is a child-window to desktop */
           NULL,                   /* No menu */
           hThisInstance,          /* Program Instance handler */
           NULL                    /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
        {
             /* Gerekli ktphane dosyasn ykleme */
             LoadLibrary(TEXT("Msftedit.dll"));

             /* Richedit kontrol oluturma */
             hwndRichedit = CreateWindowEx(0, MSFTEDIT_CLASS, TEXT("Type here"),
                    ES_MULTILINE | WS_VISIBLE | WS_CHILD | WS_BORDER | WS_VSCROLL | ES_AUTOVSCROLL,
                    10, 10, 400, 320,
                    hwnd, (HMENU)IDC_RICHEDIT, 0, NULL);

             /* Richedit kontrol ieriini dosyadan doldurma */
             FillRichEditFromFile(hwndRichedit, "richedit.rtf");
        }
        break;

        case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
        default:                       /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

/* Richedit kontroln dosyadan dolduran fonksiyon */
BOOL FillRichEditFromFile(HWND hwnd, LPCTSTR pszFile)
{
  BOOL fSuccess = FALSE;
  HANDLE hFile = CreateFile(pszFile, GENERIC_READ, FILE_SHARE_READ,
                            0, OPEN_EXISTING,
                            FILE_FLAG_SEQUENTIAL_SCAN, NULL);

  if (hFile != INVALID_HANDLE_VALUE) {
      EDITSTREAM es = { (DWORD_PTR)hFile, 0, EditStreamCallback };
      if (SendMessage(hwnd, EM_STREAMIN, SF_RTF, (LPARAM)&es) && es.dwError == 0) {
          fSuccess = TRUE;
      }
      CloseHandle(hFile);
  }
  return fSuccess;
}

DWORD CALLBACK EditStreamCallback(DWORD_PTR dwCookie, LPBYTE lpBuff, LONG cb, PLONG pcb)
{
  HANDLE hFile = (HANDLE)dwCookie;
  return !ReadFile(hFile, lpBuff, cb, (DWORD *)pcb, NULL);
}







/*
BOOL PrintRTF(HWND hwnd, HDC hdc)
{
    DOCINFO di = { sizeof(di) };

    if (!StartDoc(hdc, &di))
    {
        return FALSE;
    }

    int cxPhysOffset = GetDeviceCaps(hdc, PHYSICALOFFSETX);
    int cyPhysOffset = GetDeviceCaps(hdc, PHYSICALOFFSETY);

    int cxPhys = GetDeviceCaps(hdc, PHYSICALWIDTH);
    int cyPhys = GetDeviceCaps(hdc, PHYSICALHEIGHT);

    // Create "print preview".
    SendMessage(hwnd, EM_SETTARGETDEVICE, (WPARAM)hdc, cxPhys/2);

    FORMATRANGE fr;

    fr.hdc       = hdc;
    fr.hdcTarget = hdc;

    // Set page rect to physical page size in twips.
    fr.rcPage.top    = 0;
    fr.rcPage.left   = 0;
    fr.rcPage.right  = MulDiv(cxPhys, 1440, GetDeviceCaps(hDC, LOGPIXELSX));
    fr.rcPage.bottom = MulDiv(cyPhys, 1440, GetDeviceCaps(hDC, LOGPIXELSY));

    // Set the rendering rectangle to the pintable area of the page.
    fr.rc.left   = cxPhysOffset;
    fr.rc.right  = cxPhysOffset + cxPhys;
    fr.rc.top    = cyPhysOffset;
    fr.rc.bottom = cyPhysOffset + cyPhys;

    SendMessage(hwnd, EM_SETSEL, 0, (LPARAM)-1);          // Select the entire contents.
    SendMessage(hwnd, EM_EXGETSEL, 0, (LPARAM)&fr.chrg);  // Get the selection into a CHARRANGE.

    BOOL fSuccess = TRUE;

    // Use GDI to print successive pages.
    while (fr.chrg.cpMin < fr.chrg.cpMax && fSuccess)
    {
        fSuccess = StartPage(hdc) > 0;

        if (!fSuccess) break;

        int cpMin = SendMessage(hwnd, EM_FORMATRANGE, TRUE, (LPARAM)&fr);

        if (cpMin <= fr.chrg.cpMin)
        {
            fSuccess = FALSE;
            break;
        }

        fr.chrg.cpMin = cpMin;
        fSuccess = EndPage(hdc) > 0;
    }

    SendMessage(hwnd, EM_FORMATRANGE, FALSE, 0);

    if (fSuccess)
    {
        EndDoc(hdc);
    }

    else

    {
        AbortDoc(hdc);
    }

    return fSuccess;

}
*/

/*

Using the EM_STREAMOUT message is the answer.

Here is the simplest example that I can construct to demonstrate. This will save the contents of a rich edit control to a file.

DWORD CALLBACK EditStreamOutCallback(DWORD_PTR dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb)
{
    HANDLE hFile = (HANDLE)dwCookie;
    DWORD NumberOfBytesWritten;
    if (!WriteFile(hFile, pbBuff, cb, &NumberOfBytesWritten, NULL))
    {
        //handle errors
        return 1;
        // or perhaps return GetLastError();
    }
    *pcb = NumberOfBytesWritten;
    return 0;
}

void SaveRichTextToFile(HWND hWnd, LPCWSTR filename)
{
    HANDLE hFile = CreateFile(filename, GENERIC_WRITE, 0, NULL,
        CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    if (hFile == INVALID_HANDLE_VALUE)
    {
        //handle errors
    }
    EDITSTREAM es = { 0 };
    es.dwCookie = (DWORD_PTR) hFile;
    es.pfnCallback = EditStreamOutCallback;
    SendMessage(hWnd, EM_STREAMOUT, SF_RTF, (LPARAM)&es);
    CloseHandle(hFile);
    if (es.dwError != 0)
    {
        //handle errors
    }
}


*/
