#if defined(UNICODE) && !defined(_UNICODE)
    #define _UNICODE
#elif defined(_UNICODE) && !defined(UNICODE)
    #define UNICODE
#endif

#include <tchar.h>
#include <windows.h>
#include <commctrl.h>
#include "resource.h"

HWND hwndTreeview;

BOOL InitTreeViewImageLists(HWND hwndTV);
HTREEITEM AddItemToTree(HWND hwndTV, LPTSTR lpszItem, int nLevel);

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
TCHAR szClassName[ ] = _T("CodeBlocksWindowsApp");

int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default colour as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                      /* Extended possibilites for variation */
           szClassName,            /* Classname */
           _T("Treeview rnei"),       /* Title Text */
           WS_OVERLAPPEDWINDOW,    /* default window */
           CW_USEDEFAULT,          /* Windows decides the position */
           CW_USEDEFAULT,          /* where the window ends up on the screen */
           544,                    /* The programs width */
           375,                    /* and height in pixels */
           HWND_DESKTOP,           /* The window is a child-window to desktop */
           NULL,                   /* No menu */
           hThisInstance,          /* Program Instance handler */
           NULL                    /* No Window Creation data */
           );

    ShowWindow (hwnd, nCmdShow);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}


/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
        {
             HTREEITEM hitem, hitem02;
             /* Treeview oluturma */
             hwndTreeview = CreateWindowEx(0, WC_TREEVIEW, TEXT("Tree View"), WS_VISIBLE | WS_CHILD | WS_BORDER | TVS_HASLINES,
                            5, 5, 320, 320,
                            hwnd, (HMENU)IDC_TREEVIEW, 0, NULL);

             /* Imagelist oluturma */
             InitTreeViewImageLists(hwndTreeview);

             /* Treeview item deerlerini ekleme */
             AddItemToTree(hwndTreeview, "Item01", 1);

             AddItemToTree(hwndTreeview, "Item02", 1);

             hitem = AddItemToTree(hwndTreeview, "Item03", 1);

             hitem02 = AddItemToTree(hwndTreeview, "Item03-01", 2);
             AddItemToTree(hwndTreeview, "Item03-01-01", 3);
             AddItemToTree(hwndTreeview, "Item03-01-02", 3);
             TreeView_Expand(hwndTreeview, hitem02, TVE_EXPAND);

             hitem02 = AddItemToTree(hwndTreeview, "Item03-02", 2);
             AddItemToTree(hwndTreeview, "Item03-02-01", 3);
             AddItemToTree(hwndTreeview, "Item03-02-02", 3);
             AddItemToTree(hwndTreeview, "Item03-02-03", 3);
             TreeView_Expand(hwndTreeview, hitem02, TVE_EXPAND);

             AddItemToTree(hwndTreeview, "Item03-03", 2);

             hitem02 = AddItemToTree(hwndTreeview, "Item03-04", 2);
             AddItemToTree(hwndTreeview, "Item03-02-01", 3);
             AddItemToTree(hwndTreeview, "Item03-02-02", 3);
             TreeView_Expand(hwndTreeview, hitem02, TVE_EXPAND);

             AddItemToTree(hwndTreeview, "Item03-05", 2);

             AddItemToTree(hwndTreeview, "Item03-06", 2);

             AddItemToTree(hwndTreeview, "Item04", 1);

             TreeView_Expand(hwndTreeview, hitem, TVE_EXPAND);
        }
        break;

        case WM_NOTIFY:
        {
            /* Alt item'lar ieren item'lar kapndnda ve aldnda farkl resim atama ilemi iin */
            if (((LPNMHDR)lParam)->hwndFrom == hwndTreeview){
                switch (((LPNMHDR)lParam)->code){
                    case TVN_ITEMEXPANDED:
                    {
                        LPNMTREEVIEW nmtv = (LPNMTREEVIEW)lParam;

                        if (nmtv->hdr.code == TVN_ITEMEXPANDED){
                            TVITEM item = nmtv->itemNew;
                            item.stateMask = TVIF_IMAGE;

                            if (nmtv->action == TVE_COLLAPSE){
                                item.iImage = 0;
                                item.iSelectedImage = 0;
                            }
                            else if (nmtv->action == TVE_EXPAND){
                                item.iImage = 1;
                                item.iSelectedImage = 1;
                            }
                            TreeView_SetItem(((LPNMHDR)lParam)->hwndFrom, &item);
                        }
                        break;
                    }
                }
            }
            break;
        }

        case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

BOOL InitTreeViewImageLists(HWND hwndTV)
{
  HIMAGELIST himl;  /* Imagelist handle */
  HICON hicon;      /* Icon handle */
  /* Imagelist oluturma (3 resim ieren) */
  if ((himl = ImageList_Create(16, 16, ILC_COLOR32, 3, 0)) == NULL) return FALSE;

  /* .ico dosyas ykleme ve resim listesine ekleme */
  hicon = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONFOLDER), IMAGE_ICON, 16, 16, LR_LOADTRANSPARENT);
  ImageList_AddIcon(himl, hicon);
  DeleteObject(hicon);

  hicon = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONOPENFOLDER), IMAGE_ICON, 16, 16, LR_LOADTRANSPARENT);
  ImageList_AddIcon(himl, hicon);
  DeleteObject(hicon);

  hicon = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICONFILE), IMAGE_ICON, 16, 16, LR_LOADTRANSPARENT);
  ImageList_AddIcon(himl, hicon);
  DeleteObject(hicon);

  /* Btn .ico dosyalar (3 adet) eklenmezse hata deeri dndrr. */
  if (ImageList_GetImageCount(himl) < 3) return FALSE;

  /* Imagelist'i Treeview kontrolne atama */
  TreeView_SetImageList(hwndTV, himl, TVSIL_NORMAL);

  return TRUE;
}

HTREEITEM AddItemToTree(HWND hwndTV, LPTSTR lpszItem, int nLevel)
{
  TVITEM tvi;
  TVINSERTSTRUCT tvins;
  static HTREEITEM hPrev = (HTREEITEM)TVI_FIRST;
  static HTREEITEM hPrevRootItem = NULL;
  static HTREEITEM hPrevLev2Item = NULL;
  HTREEITEM hti;

  tvi.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

  /* Metin deerlerini atama */
  tvi.pszText = lpszItem;
  tvi.cchTextMax = sizeof(tvi.pszText)/sizeof(tvi.pszText[0]);

  /* Item'n parent olmadn yani alt item'lar iermediini kabul ederek dosya icon resmini atama */
  tvi.iImage = 2;
  tvi.iSelectedImage = 2;

  /* Item verilerini atama */
  tvi.lParam = (LPARAM)nLevel;
  tvins.item = tvi;
  tvins.hInsertAfter = hPrev;

  /* Tanmlanan seviyeye gre parent item' ayarlama */
  if (nLevel == 1) tvins.hParent = TVI_ROOT;
  else if (nLevel == 2) tvins.hParent = hPrevRootItem;
  else tvins.hParent = hPrevLev2Item;

  /* Item' Treeview kontrolne kaydetme */
  hPrev = (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)(LPTVINSERTSTRUCT)&tvins);

  if (hPrev == NULL) return NULL;

  /* Handle deerini item'a kaydetme */
  if (nLevel == 1) hPrevRootItem = hPrev;
  else if (nLevel == 2) hPrevLev2Item = hPrev;

  /* Yeni item dier bir item altnda oluturulmusa, parent item'a
     alt item2lar ierdiini gsteren kapal klasr resmini atama ilemi */
  if (nLevel > 1) {
      hti = TreeView_GetParent(hwndTV, hPrev);
      tvi.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
      tvi.hItem = hti;
      tvi.iImage = 0;
      tvi.iSelectedImage = 0;
      TreeView_SetItem(hwndTV, &tvi);
  }

  return hPrev;
}
