<?php 

namespace App\Controllers;

use Core\{Controller, Router};
use App\Models\Articles;

class HomeController extends Controller {

    public function indexAction($pageno='') {
		$params = [
            'columns' => "*",
            'order' => 'articles.id DESC'
        ];  
        $this->view->total = Articles::find_total($params); // articles tablosundaki toplam kayıt sayısı		
		[$params, $page] = Articles::merge_with_pagination($params, $pageno, $this->view->total);
			
  	    $this->view->limit = $params['limit'];
	    $this->view->page = $page;
		
        $this->view->articles = Articles::find($params); // articles tablosundaki tüm kayıt bilgileri bir nesne dizisine aktarılır.
		$this->view->heading = "Son makaleler";
        $this->view->set_site_title('Son makaleler');
		
		$this->view->render();
    }

    public function detailsAction($id) {
        $params = [
            'columns' => "*",
			'conditions' => "articles.id = :id",
            'bind' => ['id' => $id]
        ];
		
		if($this->request->isPost()) {
		   $params['bind']['id'] = $this->request->get('article_id');
		   
		   $article = Articles::find_first($params);		  
		   
		   echo(json_encode($article));
		}	 		
		else {
		   $article = Articles::find_first($params);
		   if(!$article) Router::redirect('exceptions/index/noarticle');
		   $this->view->article = $article;

		   unset($params['conditions']);
		   unset($params['bind']);
		   $params['order'] = 'articles.id DESC';
		   
		   $this->view->articles = Articles::find($params);

		   $this->view->render();
		}
    }
    
}
