<?php 
namespace App\Controllers;

use Core\{Controller, H, Session, Router};
use App\Models\Users;

class RegisterController extends Controller {
    
	public function registerAction() {
		        
        $user = new Users();

        // Form gönderme
		if($this->request->isPost()){
		   Session::csrf_check();
           $fields = ['fname', 'lname', 'email', 'acl', 'password', 'confirm'];
           foreach($fields as $field) {
			  if($field=='acl') {
				 $user->{$field} = 'user';
			  }	
              else { 
				 $user->{$field} = $this->request->get($field);
			  }
           }

           if($user->save()) {
              $msg = "Kullanıcı oluşturuldu";
              Session::msg($msg, 'success');
              Router::redirect('register/login');
           }
        }
		
        $this->view->user = $user;
        $this->view->errors = $user->get_errors();
        $this->view->render();		
    }

    public function loginAction() {
        $user = new Users();
        $isError = true;

        // Form gönderme
		if($this->request->isPost()) {
            Session::csrf_check();
            $user->email = $this->request->get('email');
            $user->password = $this->request->get('password');
            $user->remember = $this->request->get('remember');
            $user->validate_login();
            
			if(empty($user->get_errors())){
               $u = Users::find_first([
                    'conditions' => "email = :email", 
                    'bind' => ['email' => $this->request->get('email')]
               ]);
               
			   if($u) {
                  $verified = password_verify($this->request->get('password'), $u->password);
                  
				  if($verified) {
                     $isError = false;
                     $remember = $this->request->get('remember') == 'on';
                     $u->login($remember);
                     Router::redirect('');
                  }
               }
            }
            
			if($isError) {
               $user->set_error('email', 'E-posta veya parola hatalı. Lütfen tekrar deneyin.');
               $user->set_error('password', '');
            }
        }
		
        $this->view->errors = $user->get_errors();
        $this->view->user = $user;
        $this->view->render();
    }

    public function logoutAction() {
        global $current_user;
        
		if($current_user) {
           $current_user->logout();
        }
        
		Router::redirect('register/login');
    }
}