<?php 
namespace App\Models;
use Core\Model;
use Core\Validators\RequiredValidator;

class Articles extends Model {
    public $total;
	protected static $table = "articles";
    public $id, $created_at, $updated_at, $title, $body;

    public function before_save() {
        $this->time_stamps();
        $this->run_validation(new RequiredValidator($this, ['field' => 'title', 'msg' => 'Başlık gerekli bir alandır.']));
        $this->run_validation(new RequiredValidator($this, ['field' => 'body', 'msg' => 'Makale içeriği gerekli bir alandır.']));
    }
}
