<?php 
namespace App\Models;

use Core\Model;

class UserSessions extends Model{
    protected static $table = 'user_sessions';
    public $id, $user_id, $hash;

    public static function find_by_user_id($user_id){
        return self::find_first([
            'conditions' => "user_id = :user_id", 
            'bind' => ['user_id' => $user_id]
        ]);
    }

    public static function find_by_hash($hash) {
        return self::find_first([
            'conditions' => "hash= :hash", 
            'bind' => ['hash' => $hash]
        ]);
    }
}