<?php 
namespace App\Models;

use Core\{Model, Session, Cookie, Config, H};
use Core\Validators\{RequiredValidator, EmailValidator, MatchesValidator, MinValidator, UniqueValidator};
use App\Models\UserSessions;

class Users extends Model {
    protected static $table = "users", $_current_user = false;
    public $id, $created_at, $updated_at, $fname, $lname, $email, $password, $acl, $remember = '', $confirm;
    public $total, $Field, $Type, $Null, $Key, $Default, $Extra;
	
    public function before_save() {
        $this->time_stamps();

        $this->run_validation(new RequiredValidator($this, ['field' => 'fname', 'msg' => "Adı gerekli bir alandır."]));
        $this->run_validation(new RequiredValidator($this, ['field' => 'lname', 'msg' => "Soyadı gerekli bir alandır."]));
        $this->run_validation(new RequiredValidator($this, ['field' => 'email', 'msg' => "E-posta gerekli bir alandır."]));
        $this->run_validation(new EmailValidator($this, ['field' => 'email', 'msg' => 'Geçerli bir e-posta adresi girmelisiniz.']));
        $this->run_validation(new UniqueValidator($this, ['field' => ['email','acl', 'lname'], 'msg' => 'Bu e-posta adresi ile kayıtlı bir kullanıcı mevcut.']));
		$this->run_validation(new RequiredValidator($this, ['field' => 'password', 'msg' => "Parola gerekli bir alandır."]));
		$this->run_validation(new RequiredValidator($this, ['field' => 'confirm', 'msg' => "Parola onayı gerekli bir alandır."]));
		$this->run_validation(new MatchesValidator($this, ['field' => 'confirm', 'rule' => $this->password, 'msg' => "Girdiğiniz parolalar uyumlu değil."]));
		$this->run_validation(new MinValidator($this, ['field' => 'password', 'rule' => 8, 'msg' => "Parola en az 8 karakterden oluşmalıdır."]));
		$this->password = password_hash($this->password, PASSWORD_DEFAULT);
    }

    public function validate_login() {
        $this->run_validation(new RequiredValidator($this, ['field' => 'email', 'msg' => "E-posta gerekli bir alandır."]));
        $this->run_validation(new RequiredValidator($this, ['field' => 'password', 'msg' => "Parola gerekli bir alandır."]));
    }

    public function login($remember = false) {
        Session::set('logged_in_user', $this->id);
        self::$_current_user = $this;
        if($remember) {
           $now  = time();
           $new_hash = md5("{$this->id}_{$now}");
           $session = UserSessions::find_by_user_id($this->id);
           if(!$session) {
              $session = new UserSessions();
           }
           $session->user_id = $this->id;
           $session->hash = $new_hash;
           $session->save();
           Cookie::set(Config::get('login_cookie_name'), $new_hash, 60 * 60 * 24 * 30);
        }
    }

    public static function login_from_cookie() {
        $cookieName = Config::get('login_cookie_name');
        if(!Cookie::exists($cookieName)) return false;
        $hash = Cookie::get($cookieName);
        $session = UserSessions::find_by_hash($hash);
        if(!$session) return false;
        $user = self::find_by_id($session->user_id);
        if($user) {
           $user->login(true);
        }
    }

    public function logout() {
        Session::delete('logged_in_user');
        self::$_current_user = false;
        $session = UserSessions::find_by_user_id($this->id);
        if($session) {
           $session->delete();
        }
        Cookie::delete(Config::get('login_cookie_name'));
    }

    public static function get_current_user() {
        if(!self::$_current_user && Session::exists('logged_in_user')) {
           $user_id = Session::get('logged_in_user');
           self::$_current_user = self::find_by_id($user_id);
        }
        if(!self::$_current_user) self::login_from_cookie();
        return self::$_current_user;
    }

    public function has_permission($acl) {
        if(is_array($acl)) {
           return in_array($this->acl, $acl);
        }
        return $this->acl == $acl;
    }
	
    public function displayName() {
        return trim($this->fname . ' ' . $this->lname);
    }
}