<?php 
  use Core\{H, Config};  
?>

<?php $this->start('content'); ?>

<?php 
if(Config::get('main_slide')) { 
   $this->inc('inc/main_slide');
}
?>

<div class="p-3">
	<nav class="navbar navbar-expand-lg bg-header">
	   <div class="container-fluid p-2">
	   
		  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#MainNavbar" aria-controls="MainNavbar" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		  </button>
	   
		  <div class="collapse navbar-collapse" id="MainNavbar">
			
			<ul class="navbar-nav">
				<li><?=$this->heading?></li>
			</ul>
		  
			<ul class="navbar-nav ms-auto mb-2 mb-lg-0 bg-fontsm">
			    <?php // Sayfada gösterilecek kayıt sayısı seçimi ?>
				<form class="mt-2" action="<?=ROOT?><?=H::get_action()?>" method="post">
					<label class="me-2" for="records_limit">Kayıt sayısı</label>
					<select name="records_limit" id="records_limit" class="custom-select">
						<?php foreach([4, 6, 8, 10] as $limit) : ?>
						<option
							<?php if(isset($_SESSION['records_limit']) && $_SESSION['records_limit'] == $limit) echo 'selected'; ?>
							value="<?= $limit; ?>">
							<?= $limit; ?>
						</option>
						<?php endforeach; ?>
					</select>
				</form>
			</ul>
			
		  </div>
	   </div>
	</nav>
	
	<?php // Makalelerin gösterimi  ?>
	<div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 row-cols-xl-5 row-cols-xxl-6 g-4">
	   <?php foreach($this->articles as $article): ?>
		 <div class="col">
			<div class="card h-100 shadow">
			  <div class="card-body">
				<h5 class="card-title"><?= $article->title ?></h5>
				<div class="bg-card-text mb-2"><?= html_entity_decode($article->body) ?></div>
				<a href="<?=ROOT?>home/details/<?=$article->id?>" class="text-info">Detaylar</a>
			  </div>
			</div>
		 </div>
       <?php endforeach; ?>
	</div>	
	
	<?php // Sayfa yapısı oluşturma ?>
	<?php $this->inc('inc/pager'); ?>

</div>

<?php $this->end(); ?>