<?php 
  use Core\{H, Router};
  global $current_user;
  $menu = Router::get_menu('menu_acl');
?>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark p-4">
  <div class="container-fluid">
  
      <a class="navbar-brand" href="<?=ROOT?>">BG MVC</a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#TopNavbar2" aria-controls="TopNavbar2" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

	  <div class="collapse navbar-collapse" id="TopNavbar2">
		<ul class="navbar-nav me-auto mb-2 mb-lg-0">
		  <?php foreach($menu as $key => $val) :
			 if(is_array($val)): ?>			
				<li class="<?php echo H::active_class($key,'nav-item dropdown'); ?>">
					<a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false"><?=$key?></a>
					<ul class="dropdown-menu">
						<?php foreach($val as $k => $v):
							     echo H::nav_item($v, $k, true);
						      endforeach;
						?>
					</ul>
				</li>					
			<?php else: 
				echo H::nav_item($val, $key);
			 endif; 
			?>
		  <?php endforeach; ?>
		</ul>
		
		<ul class="navbar-nav d-flex">
		  <?php if(!$current_user): ?>
			  <?= H::nav_item('register/login', 'Giriş yap'); ?>
		  <?php endif; ?>

		  <?php if($current_user): ?>
			  <li class="nav-item dropdown">
				  <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">Merhaba <?= $current_user->fname;?></a>
				  <ul class="dropdown-menu dropdown-menu-right">							
					<?= H::nav_item('register/logout', 'Çıkış', true); ?>
				  </ul>
			  </li>
		  <?php endif; ?>
		</ul>			

	  </div>  
  </div>
</nav>