<?php 
namespace Core;

use Core\{View, Config, Request};

class Controller {
    private $_controller_name, $_action_name;
    public $view, $request;

    public function __construct($controller, $action) {        
		$this->_controller_name = $controller;
        $this->_action_name = $action;
        $view_path = strtolower($controller) . '/' .$action; // 'Home/index'
        $this->view = new View($view_path);
        $this->view->set_layout(Config::get('default_layout'));
        $this->request = new Request();
        $this->onConstruct();
    }

    public function onConstruct(){}
}