<?php 
namespace Core;

use \PDO;
use \Exception;
use Core\{Config, H};

class DB {
    protected $_dbh, $_results, $_last_insert_id, $_row_count = 0, $_fetch_type = PDO::FETCH_OBJ, $_class, $_error = false;
    protected $_stmt;
    protected static $_db;
	
    public function __construct() {
        $host = Config::get('db_host');
        $name = Config::get('db_name');
        $user = Config::get('db_user');
        $pass = Config::get('db_password');
        $options = [
            PDO::ATTR_EMULATE_PREPARES => false, 
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ,
			PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8mb4 COLLATE utf8mb4_turkish_ci' // SET NAMES komutu PHP 5.3.6 öncesi için 
        ];
        try {
            $this->_dbh = new PDO("mysql:host={$host};dbname={$name};charset=utf8mb4", $user, $pass, $options);
        } 
		catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public static function get_instance() {
        if(!self::$_db) {
           self::$_db = new self();
        }
        return self::$_db;
    }

    public function execute($sql, $bind=[]) {
        $this->_results = null;
        $this->_last_insert_id = null;
        $this->_error = false;
		
        $this->_stmt = $this->_dbh->prepare($sql);
        if(!$this->_stmt->execute($bind)) {
		   $this->_error = true;
        } 
		else {
           $this->_last_insert_id = $this->_dbh->lastInsertId();
        }

        return $this;
    }

    public function query($sql, $bind=[]) {
		$this->execute($sql, $bind);
        
		if(!$this->_error) {
           $this->_row_count = $this->_stmt->rowCount();
           if($this->_fetch_type === PDO::FETCH_CLASS) {
              $this->_results = $this->_stmt->fetchAll($this->_fetch_type, $this->_class);
           } 
		   else {
              $this->_results = $this->_stmt->fetchAll($this->_fetch_type);
           }
        }
		
        return $this;
    }

    public function insert($table, $values) {
        $fields = [];
        $binds = [];
        foreach($values as $key => $value) {
            $fields[] = $key;
            $binds[] = ":{$key}";
        }
        $field_str = implode('`, `', $fields);
        $bind_str = implode(', ', $binds);
        $sql = "INSERT INTO {$table} (`{$field_str}`) VALUES ({$bind_str})";
        $this->execute($sql, $values);
		
        return !$this->_error;
    }

    public function update($table, $values, $conditions) {
        $binds = [];
        $value_str = "";
        foreach($values as $field => $value) {
            $value_str .= ", `{$field}` = :{$field}";
            $binds[$field] = $value;
        }
        $value_str = ltrim($value_str, ', ');
        $sql = "UPDATE {$table} SET {$value_str}";

        if(!empty($conditions)) {
            $condition_str = " WHERE ";
            foreach($conditions as $field => $value) {
                $condition_str .= "`{$field}` = :cond{$field} AND ";
                $binds['cond'.$field] = $value;
            }
            $condition_str = rtrim($condition_str, ' AND ');
            $sql .= $condition_str;
        }
        $this->execute($sql, $binds);
        return !$this->_error;
    }

    public function results() {
        return $this->_results;
    }

    public function count() {
        return $this->_row_count;
    }

    public function last_insert_id() {
        return $this->_last_insert_id;
    }

    public function set_class($class) {
        $this->_class = $class;
    }

    public function get_class() {
        return $this->_class;
    }

    public function set_fetch_type($type) {
        $this->_fetch_type = $type;
    }

    public function get_fetch_type() {
        return $this->_fetch_type;
    }
}