<?php 
namespace Core;

class FH {
	
    public static function input_block($label, $id, $value, $input_attrs =[], $wrapper_attrs = [], $errors = []) {
        $wrapper_str = self::process_attrs($wrapper_attrs);
        $input_attrs = self::append_errors($id, $input_attrs, $errors);
        $input_attrs = self::process_attrs($input_attrs);
        $error_msg = array_key_exists($id, $errors)? $errors[$id] : "";
        $html = "<div {$wrapper_str}>";
        $html .= "<label for='{$id}' class='form-label small'>{$label}</label>";
        $html .= "<input id='{$id}' name='{$id}' value='{$value}' {$input_attrs} />";
        $html .= "<div class='invalid-feedback'>{$error_msg}</div></div>";
        return $html;
    }

    public static function select_block($label, $id, $value, $options, $input_attrs=[], $wrapper_attrs=[], $errors=[]) {
        
		$input_attrs = self::append_errors($id, $input_attrs, $errors);
        $input_attrs = self::process_attrs($input_attrs);
        $wrapper_str = self::process_attrs($wrapper_attrs);
        $error_msg = array_key_exists($id, $errors)? $errors[$id] : "";
        $html = "<div {$wrapper_str}>";
        $html .= "<label for='{$id}' class='form-label small'>{$label}</label>";
        $html .= "<select id='{$id}' name='{$id}' {$input_attrs}>";
        foreach($options as $val => $display) {
            $selected = $val == $value? ' selected ' : "";
            $html .= "<option value='{$val}'{$selected}>{$display}</option>";
        }
        $html .= "</select>";
        $html .= "<div class='invalid-feedback'>{$error_msg}</div></div>";
        return $html;
    }

    public static function check($label, $id, $checked = '', $input_attrs=[], $wrapper_attrs=[], $errors=[]) {
        $input_attrs = self::append_errors($id, $input_attrs, $errors);
        $wrapper_str = self::process_attrs($wrapper_attrs);
        $input_str = self::process_attrs($input_attrs);
        $checked_str = $checked == 'on'? "checked" : "";
        $html = "<div {$wrapper_str}>";
        $html .= "<input type=\"checkbox\" id=\"{$id}\" name=\"{$id}\" {$input_str} {$checked_str}>";
        $html .= "<label class=\"form-check-label\" for=\"{$id}\">{$label}</label></div>";
        return $html;
    }

    public static function text_area($label, $id, $value, $input_attrs =[], $wrapper_attrs = [], $errors = []) {
        $wrapper_str = self::process_attrs($wrapper_attrs);
        $input_attrs = self::append_errors($id, $input_attrs, $errors);
        $input_attrs = self::process_attrs($input_attrs);
        $error_msg = array_key_exists($id, $errors)? $errors[$id] : "";
        $html = "<div {$wrapper_str}>";
        $html .= "<label for='{$id}' class='form-label small'>{$label}</label>";
        $html .= "<textarea id='{$id}' name='{$id}' value='{$value}' {$input_attrs}>{$value}</textarea>";
        $html .= "<div class='invalid-feedback'>{$error_msg}</div></div>";
        return $html;		
    }

    public static function append_errors($key, $input_attrs, $errors) {
        if(array_key_exists($key, $errors)) {
            if(array_key_exists('class', $input_attrs)) {
               $input_attrs['class'] .= ' is-invalid';
            } 
			else {
               $input_attrs['class'] = 'is-invalid';
            }
        }
        return $input_attrs;
    }

    public static function process_attrs($attrs) {
        $html = "";
        foreach($attrs as $key => $value) {
            $html .= " {$key}='{$value}'";
        }
        return $html;
    }

    public static function csrf_field(){
        $token = Session::create_csrf_token();
        $html = "<input type='hidden' value='{$token}' name='csrfToken' />";
        return $html;
    }
}