<?php 
namespace Core;

class H {
	
    public static function remove_root($url) {
		// '/bgmvc/' -> ''
		// '/bgmvc/home' -> 'home'
		// '/bgmvc/home/details/11' -> '/home/details/11'
		// '/home' -> 'home'
		if(ROOT != '/') { // En soldaki '/bgmvc/' (Lokal sunucu) veya '/' (Uzak sunucu) değerini kaldırma
		   $url = str_replace(ROOT, '', $url);
		} 
		else { // '/' değerini kaldırma (Canlı sunucu) $url = '/' -> $url = ''
		   $url = ltrim($url, '/'); 
		}	
	
	    // $url değerinin en sağında yer alabilecek id=21&md=34 gibi değerleri silmek için
		$url = preg_replace('/(\?.+)/', '', $url); 
	
	    return $url;
    }	

    public static function get_action() {
        // global $current_page;
		// $url = '', 'home' 'home/index' 'home/index/3' 'home/author/4' 'home/author/4/2' 'home/category/4' 'home/category/4/2'
        // 'admin/articles' 'admin/articles/3' 'admin/users' 'admin/users/3' 'admin/categories' 'admin/categories/3'
		$url = self::remove_root($_SERVER['REQUEST_URI']);         
		$url = explode ('/', $url);
        
		// home/author/4/2 ($authorId, $pageno='') ve home/category/4/2 ($categoryId, $pageno='') action fonksiyonlarına 2 parametre istiyor.
		// home/index/3, admin/articles/3, admin/users/3 ve admin/categories/3 action fonksiyonlarına 1 parametre istiyor. $pageno=''
		$link = ((isset($url[0]) && $url[0]!='') ? $url[0] : 'home') . '/' . (isset($url[1]) ? $url[1] : 'index') . (isset($url[2]) && ($url[1]=='author' || $url[1]=='category') ? ('/' . $url[2]) : '');
		
        return $link;
    }	

    public static function dnd($data=[], $die = true){
        echo "<pre>";
        var_dump($data);
        echo "</pre>";
        if($die) {
           die;
        }
    }

    public static function is_current_page($page) {
        global $current_page;
		
		if(!empty($page) && strpos($page, ':id') > -1) {
            $page = str_replace(":id", "", $page);
			return strpos($current_page, $page) > -1;
        }
		return $page == $current_page;
    }
	
    public static function active_class($page, $class = '') {
        $active = self::is_current_page($page);
        $class = $active ? $class . " active" : $class;
		
        return $class;
    }

    public static function nav_item($link, $label, $is_dropdown_item = false) {
		$active = self::is_current_page($link);		
        $class = self::active_class($link, 'nav-item');
        $link_class = $is_dropdown_item ? 'dropdown-item' : 'nav-link';
        $link_class .= $active ? " active" : "";
        $link = ROOT . $link;
		
        $html = "<li>";
        $html .= "<a class=\"{$link_class}\" href=\"{$link}\" >{$label}</a>";
        $html .= "</li>";
        return $html;
    }
    
}