<?php 
namespace Core;

class Request {

    public function isPost() {
        return $this->get_request_method() === 'POST';
    }

    public function isPut(){
        return $this->get_request_method() === 'PUT';
    }

    public function isGet(){
        return $this->get_request_method() === 'GET';
    }

    public function isDelete(){
        return $this->get_request_method() === 'DELETE';
    }

    public function isPatch(){
        return $this->get_request_method() === 'PATCH';
    }

    public function get_request_method(){
        return strtoupper($_SERVER['REQUEST_METHOD']);
    }

    public function get($input = false) {
        if(!$input) {
           $data = [];
           
		   foreach($_REQUEST as $field => $value) {
               $data[$field] = self::sanitize($value);
           }
           
		   return $data;
        }
        return array_key_exists($input, $_REQUEST) ? self::sanitize($_REQUEST[$input]) : false;
    }

    public static function sanitize($dirty) {
        return htmlentities(trim($dirty), ENT_QUOTES, "UTF-8");
    }

}