<?php 
namespace Core;

use Core\{Config, Router};

class View {
    public $articles, $total, $heading;
	public $errors, $user, $header, $users, $article;
	public $msg, $msg_txt, $limit, $page, $url;
	
	private $_site_title = '', $_content = [], $_current_content, $_buffer, $_layout;
    private $_default_view_path;

    public function __construct($path = '') {
       $this->_default_view_path = $path;
       $this->_site_title = Config::get('default_site_title');
    }

    public function set_layout($layout) {
        $this->_layout = $layout;
    }

    public function set_site_title($title) {
        $this->_site_title = $title;
    }

    public function get_site_title() {
        return $this->_site_title;
    }

    public function render($path = '') {
        if(empty($path)) {
           $path = $this->_default_view_path;
        }
		
        $layout_path = FROOT . DS . 'app' . DS . 'views' . DS . 'layouts' . DS . $this->_layout . '.php';
        $full_path = FROOT . DS . 'app' . DS . 'views' . DS . $path . '.php';
		
		if(!file_exists($full_path)) {
           Router::redirect('exceptions/index/noview');
        }
        if(!file_exists($layout_path)) {
           Router::redirect('exceptions/index/notemplate');
        }
        
		include($full_path);
        include($layout_path);
    }

    public function start($key) {		
		if(empty($key)) {
		   Router::redirect('exceptions/index/nokey');	
        }
        $this->_buffer = $key;
		
        ob_start();
    }

    public function end() {
        if(empty($this->_buffer)) {
		   Router::redirect('exceptions/index/nostart');	
        } 
        $this->_content[$this->_buffer] = ob_get_clean();
        $this->_buffer = null;
    }

    public function content($key) {
        if(array_key_exists($key, $this->_content)) {
           echo $this->_content[$key];
        } 
		else {
           echo '';
        }
    }

    public function inc($path) {
		$full_path = FROOT . DS . 'app' . DS . 'views' . DS . $path . '.php';

		if(file_exists($full_path)) {           
		   include($full_path);
        }
    }
}