<?php 
namespace Core\Validators;
use Core\Validators\Validator;

class UniqueValidator extends Validator {

    public function run_validation(){
        $value = $this->_obj->{$this->field};
        if($value == '' || !isset($value)) {
           return true;
        }

        $conditions = "{$this->field} = :{$this->field}";
        $bind = [$this->field => $value];

        if(!$this->_obj->is_new()) {
           $conditions .= " AND id != :id";
           $bind['id'] = $this->_obj->id;
        }

        foreach($this->additional_field_data as $adds) {
           $conditions .= " AND {$adds} = :{$adds}";
           $bind[$adds] = $this->_obj->{$adds};
        }

        $queryParams = ['conditions' => $conditions, 'bind' => $bind];

        $exists = $this->_obj::find_first($queryParams);

        return !$exists;
    }
}