<?php 
namespace Core\Validators;

abstract class Validator {

    public $success = true, $msg = '', $field, $additional_field_data=[], $rule, $include_deleted = false;
    protected $_obj;

    public function __construct($obj, $params) {
        $this->_obj = $obj;

        if(!array_key_exists('field', $params)) {
           throw new \Exception("params dizisine bir alan eklemelisiniz!");
        }

        $this->field = $params['field'];
        if(is_array($params['field'])) {
           $this->field = $params['field'][0];
           array_shift($params['field']);
           $this->additional_field_data = $params['field'];
        }

        if(!property_exists($this->_obj, $this->field)) {
           throw new \Exception("Alan değeri model nesnesi üzerinde bir özellik olarak yer almalıdır!");
        }

        if(!array_key_exists('msg', $params)) {
           throw new \Exception("params dizisine bir msg değeri eklemelisiniz!");
        }
        $this->msg = $params['msg'];

        if(array_key_exists('rule', $params)) {
           $this->rule = $params['rule'];
        }

        if(array_key_exists('include_deleted', $params) && $params['include_deleted']) {
           $this->include_deleted = true;
        }

        try {
           $this->success = $this->run_validation();
        } 
		catch(\Exception $e) {
           echo get_class() . " ile ilgili doğrulama sorunu: " . $e->getMessage() . "<br />";
        }
    }

    abstract public function run_validation();
}