<?php 
session_start(); // Oturum başlatma

// Sınıfı kullanımları
use \Core\{Config, Router, H};
use App\Models\Users;
use Dotenv\Dotenv;

// Sabit bildirimleri
define('FROOT', __DIR__); // Fiziksel dosya yol tanımlaması (C:\wamp\www\bgmvc)
define('DS', DIRECTORY_SEPARATOR);

// Composer tarafından yüklenen bileşenleri otomatik olarak yükleme
require_once('./vendor/autoload.php');

// Dotenv bileşeni oluşturma
$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->safeLoad();

// Otomatik sınıf dosyası yükleme fonksiyonu
spl_autoload_register(function($className){
    $parts = explode('\\', $className);
    $class = end($parts);
    array_pop($parts);
    $path = strtolower(implode(DS, $parts));
    $path = FROOT . DS . $path . DS . $class . '.php';
    if(file_exists($path)) {
       include($path);
    } 
});

// Kullanıcı bağlı ise kullanıcı bilgilerini içeren bir nesne, değilse false değeri geri döndürür.
$current_user = Users::get_current_user();

// Config.php dosyasındaki Config sınıfı içindeki get() fonksiyonu ile 
// ana dizinde bulunan env dosyasındaki root_dir değerini okuma
$root_dir = Config::get('root_dir'); // '/bgmvc/'

// Tanımlanan ROOT sabitine Lokal sunucu ise '/bgmvc/' değerini, uzak sunucu ise '/' değerini atar.
define('ROOT', ($_SERVER['SERVER_NAME']==='localhost') ? $root_dir : '/'); // Lokal='/bgmvc/' Live='/'

// Lokal sunucu ise '/bgmvc/' değerini, uzak sunucu ise '/' değerini URL değerinin başından siler.
// Lokal: '/bgmvc/' -> '', '/bgmvc/home' -> 'home' Live: '/' -> '' '/home' -> 'home'
$url = H::remove_root($_SERVER['REQUEST_URI']); 

// İlk giriş ise sadece boş bir dizi, değilse denetleyici (controller), hareket (action) ve parametreler içerir.
$current_page = $url; // '', 'home', '/home/details/11', 'activities/software', 'about'

// '/' değeri ile ayrılmış olan denetleyici, hareket ve parametre değerleri bir diziye atanır. 
$url = explode ('/', $url); 

// var_dump($url);

Router::route($url); // Router'a yönlendirme
